/*******************************************************
Filename		:  	DW_result_hub_custom.sql
Release 		:  	STORET c2.0, C2.0.1
SIR			:  	1446, 1560, 1557
Description		:  	Gatekeeper procedure that produces a shell HTML page
				and calls the procedure to generate a report or view a list
				of stations based on the user selection.
Author			:  	Joseph Wilson
Date			: 	March 4, 2003 --changed table type to vc_arr
                  	:     	April 30, 2003 - Pass the number '7' to the footer to be used to bookmark Help - W.Nash
			:	June 27, 2003 - Pass HINTS for report creation -JW
				July 22, 2003 - pass report type -JW
                        	08/15/2003 - Removed 'BETA' from the page title. -CT
				10/14/2003 - Added report filesize estimates (SIR 1560)-JW
                        	11/04/2003 - Updated to allow file to be gzipped. (SIR 1557)-CT
                        	11/13/2003 - Removed zip file question; changed button label. -CT
				02/12/2004 - Change zip button to anchor link and reformatted page -JW 
	10/19/2004 - Receives v_filters parameter and uses it in recording data requests. -GT
	10/19/2004 - Calls dw_record_data_request procedure to record the data request. -GT
Comments		:  	Displays a link to the report file created by the report generating
				procedure.  
**********************************************************/

CREATE OR REPLACE PROCEDURE DW_Result_Hub_Custom
(v_FromStmt		IN	VARCHAR2,
v_WhereStmt		IN 	VARCHAR2,
v_ResultCount		IN 	VARCHAR2,
v_rule_optimization	IN	VARCHAR2,
v_report_type		IN	CHAR,
v_filters		IN	VARCHAR2,
v_mode 			IN	VARCHAR2,
v_email			IN      VARCHAR2 default 'No_Email_Provided',
v_prefix		in      varchar2 default 'EPA',
v_Columns 		owa_util.vc_arr,
--v_ActColumns	owa_util.ident_arr,
report_type 		varchar2 :='CUSTOM'
)
AS

v_exists 		boolean;
v_file_length 		number;
v_blocksize 		number;

program_path  		varchar2(1000) := null;
script_path   		varchar2(1000) := null;
image_path    		varchar2(1000) := null;
page_title    		varchar2(100);
--v_request_id            number;
--
--The out_file variable will contain the entire URL of the file created within 
--the called download procedures.
--
out_file	  	varchar2(200);

lv_file_name varchar2(100);
lv_filetype varchar2(3);
lv_timestamp varchar2(20);
lv_file_length number;

lv_request_id dw_data_requests.request_id%type;
lv_email dw_data_requests.email_address%type;
lv_prefix varchar2(3);


BEGIN

    if v_mode = 'Online' then
	page_title :='Download Results';
	DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
	htp.print('<form action="DW_result_download_zip" method=POST>');
	htp.para;
	htp.para;
	htp.para;
	htp.print('<center>');
--htp.print(v_wherestmt);
	IF report_type = 'CUSTOM' THEN
  	  htp.print('You have requested to download monitoring Results');
  DW_result_download_custom(v_FromStmt,v_WhereStmt,v_rule_optimization,v_report_type,v_Columns,'NONE',null,null,v_mode,v_ResultCount,v_filters,out_file,lv_request_id);
	END IF;
	utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,out_file,v_exists,v_file_length,v_blocksize);
	htp.print('<br><br>The size of your report download is <B>'||ROUND(v_file_length/1024,1)||'KB</B>');
	htp.Br;
	htp.Br;
	htp.anchor(out_file,htf.bold('Download your file now...'));
	htp.Br;
	lv_file_length:=ROUND(v_file_length/1024,1);
      htp.Br;
	htp.print('or, for large files, you may click below to compress before download');
	htp.Br;
	htp.Br;
	htp.print('<a HREF="javascript:document.forms[1].submit();">Compress data file now...</a>');
	htp.print('</center>');
	htp.print('<input type="hidden" name="out_file" value='||out_file||'>');
	htp.print('</center>');
	DW_bottom_of_page(7);
  --sir1633

  elsif v_mode in ('Immediate','Overnight') then 
      if v_email is null then
        lv_email:='NoEmailProvided';
      else
        lv_email:=v_email;
      end if;
      if v_prefix is null then
        lv_prefix:='EPA';
      else
        lv_prefix:=v_prefix;
      end if;
     
    -- record Overnight/Immediate request and return a filename.
	page_title :='Result Data request via '||v_mode||' batch process';

	DW_TOP_OF_PAGE(page_title, program_path, script_path, image_path);
           htp.print('<center>');

	IF report_type = 'CUSTOM' THEN
		htp.print('You have requested for a custom result download via '||v_mode||' batch processing.');
DW_result_download_custom(v_FromStmt,v_WhereStmt,v_rule_optimization,v_report_type,v_Columns,'NONE',lv_email,lv_prefix,v_mode,v_ResultCount,v_filters,out_file,lv_request_id);

	END IF;
          htp.print('The Request is sucessfully submitted.  A confirmation is sent to the email address you provided.');
          htp.br;
	  htp.br;
          htp.br;
          htp.print('<table cols=1 align="center" border=0>
           <tr><td align=Center><B>Request Information </B> </td></tr>
           <tr><td align=left>Request ID    : '||lv_request_id||'  </td></tr>
           <tr><td align=left>Request Type  : Result Download  </td></tr>
           <tr><td align=left>Record Count  : '||v_ResultCount  ||'  </td></tr>
           <tr><td align=left>Request Mode  : '||v_mode   ||' batch </td></tr>
           <tr><td align=left>File Name     : '||out_file||'.'||dw_glob_var.gv_cmprs_fl_ext ||'  </td></tr>
           <tr><td align=left>URL     : '||dw_glob_var.lv_download_path||out_file||'.'||dw_glob_var.gv_cmprs_fl_ext ||'  </td></tr>
           <tr><td align=left>Email Address : '||lv_email||'  </td></tr>
           <tr><td> </td> </tr>
           <tr><td align=left>You will be notified when the request is processed.   </td></tr> 
         </table>');
           
            htp.print('<form><input type="button" value="  <<Back  " width=40 onClick=Close_Onclick();></form></center>');

	DW_bottom_of_page(7);

  end if;

END;
/
show errors